using System;
using Server;

namespace Server.Items
{
	public class LevelOrnamentOfTheMagician : LevelGoldBracelet
	{
		public override int LabelNumber{ get{ return 1061105; } } // Ornament of the Magician
		public override int ArtifactRarity{ get{ return 11; } }

		[Constructable]
		public LevelOrnamentOfTheMagician()
		{
			Hue = 0x554;
			Attributes.CastRecovery = 3;
			Attributes.CastSpeed = 2;
			Attributes.LowerManaCost = 10;
			Attributes.LowerRegCost = 20;
			Resistances.Energy = 15;
         
			SkillBonuses.SetValues( 0, SkillName.Magery, 10 );
			SkillBonuses.SetValues( 1, SkillName.EvalInt, 10 );
		}
      
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Forced mana regeneration<basefont color=White>" );
		}

		public LevelOrnamentOfTheMagician( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( version == 0 )
         {
			   SkillBonuses.SetValues( 0, SkillName.Magery, 10 );
			   SkillBonuses.SetValues( 1, SkillName.EvalInt, 10 );
         }
		}
	}
}